/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import java.lang.reflect.Method;
import krister.Ess.Ess;

public final class AudioInput {
    private FadeThread fadeThread;
    private RecordThread recordThread;
    private float rVolume;
    private float rGain;
    private boolean rMute;
    private boolean rFading;
    private int rBufferStartTime;
    private float rSampleRate;
    private int rState;
    private EventDispatcher audioInputFadeED;
    private Method audioInputDataMethod;
    private AudioInput thisInput;
    private boolean updateBuffer2;
    public int bufferStartTime;
    public float[] buffer;
    public float[] buffer2;
    public float sampleRate;
    public int state;
    public int duration;
    public int size;
    public float volume;
    public float gain;
    public boolean mute;
    public boolean fading;
    static /* synthetic */ Class class$krister$Ess$AudioInput;

    public AudioInput() {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, 44100.0f);
    }

    public AudioInput(int n) {
        this.setup(n, 44100.0f);
    }

    public AudioInput(int n, float f) {
        this.setup(n, f);
    }

    public void destroy() {
        if (this.audioInputFadeED != null) {
            this.audioInputFadeED.kill = true;
        }
        this.stopSound();
        this.audioInputFadeED = null;
        this.recordThread = null;
        this.fadeThread = null;
        Ess.unregisterAudioInput(this);
    }

    public void start() {
        if (this.rState != 3) {
            if (Ess.activeAudioInput != this) {
                Ess.startInput(this, this.buffer.length, this.rSampleRate);
            }
            new Thread(Ess.tg, this.recordThread).start();
        }
    }

    public void stop() {
        this.stopSound();
    }

    public void sampleRate(float f) {
        this.stopSound();
        if (Ess.activeAudioInput == this) {
            Ess.startInput(this, this.buffer.length, f);
        }
        this.sampleRate = this.rSampleRate = f;
    }

    public void bufferSize(int n) {
        this.stopSound();
        if (Ess.activeAudioInput == this) {
            Ess.startInput(this, n, this.rSampleRate);
        }
        this.buffer = new float[n];
        this.duration = this.ms(n);
        this.size = n;
    }

    public int ms(int n) {
        return (int)((float)n / this.rSampleRate * 1000.0f);
    }

    public int frames(int n) {
        return (int)((float)n * this.rSampleRate / 1000.0f);
    }

    public void volume(float f) {
        this.volume = this.rVolume = f;
        this.gain = this.rGain = (float)(Math.log(f) / Math.log(10.0) * 20.0);
    }

    public void gain(float f) {
        this.gain = this.rGain = f;
        this.volume = this.rVolume = (float)Math.pow(10.0, (double)f / 20.0);
    }

    public void mute(boolean bl) {
        this.mute = this.rMute = bl;
    }

    public void fadeTo(float f, int n) {
        this.fadeTo(f, n, 3);
    }

    public void fadeTo(float f, int n, int n2) {
        this.stopFade();
        this.fadeThread.setup(f, n, n2);
        new Thread(Ess.tg, this.fadeThread).start();
    }

    public void stopFade() {
        this.fadeThread.stop();
    }

    protected final int getBufferStartTime() {
        return this.rBufferStartTime;
    }

    protected final int getState() {
        return this.rState;
    }

    private void setup(int n, float f) {
        this.recordThread = new RecordThread();
        this.fadeThread = new FadeThread();
        this.updateBuffer2 = true;
        this.sampleRate = this.rSampleRate = f;
        this.rState = 1;
        this.state = 1;
        this.volume(1.0f);
        this.mute(false);
        this.buffer = new float[n];
        this.buffer2 = new float[n * 2];
        this.duration = this.ms(n);
        this.size = n;
        Ess.registerAudioInput(this);
        try {
            this.audioInputDataMethod = Ess.parent.getClass().getMethod("audioInputData", class$krister$Ess$AudioInput == null ? (class$krister$Ess$AudioInput = AudioInput.class$("krister.Ess.AudioInput")) : class$krister$Ess$AudioInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Method method = Ess.parent.getClass().getMethod("audioInputFade", class$krister$Ess$AudioInput == null ? (class$krister$Ess$AudioInput = AudioInput.class$("krister.Ess.AudioInput")) : class$krister$Ess$AudioInput);
            this.audioInputFadeED = new EventDispatcher(method, this);
            new Thread(Ess.tg, this.audioInputFadeED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thisInput = this;
    }

    private void stopSound() {
        this.recordThread.stop();
        Ess.stopInput(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final class EventDispatcher
    implements Runnable {
        public boolean kill;
        public boolean trigger;
        private Method theMethod;
        private AudioInput parent;

        EventDispatcher(Method method, AudioInput audioInput2) {
            this.theMethod = method;
            this.parent = audioInput2;
        }

        public void run() {
            this.trigger = false;
            this.kill = false;
            while (!this.kill) {
                if (this.trigger) {
                    try {
                        this.theMethod.invoke((Object)Ess.parent, this.parent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.trigger = false;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected final class FadeThread
    implements Runnable {
        private long startTime;
        private int duration;
        private int curve;
        private float startVolume;
        private float targetVolume;
        public boolean kill;

        protected FadeThread() {
        }

        public void run() {
            this.kill = false;
            AudioInput.this.fading = AudioInput.this.rFading = true;
            this.startTime = System.currentTimeMillis();
            this.startVolume = AudioInput.this.rVolume;
            while (System.currentTimeMillis() < this.startTime + (long)this.duration && !this.kill) {
                float f = this.startVolume;
                float f2 = Math.min(1.0f, (float)(System.currentTimeMillis() - this.startTime) / (float)this.duration);
                switch (this.curve) {
                    case 1: {
                        f = Ess.semiBezier(this.startVolume, this.targetVolume, (this.startVolume * 3.0f + this.targetVolume) / 4.0f, f2);
                        break;
                    }
                    case 2: {
                        f = Ess.semiBezier(this.startVolume, this.targetVolume, (this.startVolume + this.targetVolume * 3.0f) / 4.0f, f2);
                        break;
                    }
                    case 3: {
                        f = (1.0f - f2) * this.startVolume + f2 * this.targetVolume;
                    }
                }
                AudioInput.this.volume(f);
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.kill) {
                AudioInput.this.volume(this.targetVolume);
                if (AudioInput.this.audioInputFadeED != null) {
                    ((AudioInput)AudioInput.this).audioInputFadeED.trigger = true;
                }
            }
            AudioInput.this.fading = AudioInput.this.rFading = false;
        }

        void setup(float f, int n, int n2) {
            this.targetVolume = f;
            this.duration = n;
            this.curve = n2;
        }

        private void stop() {
            this.kill = true;
            while (AudioInput.this.rFading) {
            }
        }
    }

    private final class RecordThread
    implements Runnable {
        public boolean kill;

        private RecordThread() {
        }

        public void run() {
            byte[] byArray = new byte[AudioInput.this.buffer.length * 2 * 2];
            this.kill = false;
            AudioInput.this.state = AudioInput.this.rState = 3;
            while (!this.kill) {
                int n = Ess.inputLine.read(byArray, 0, byArray.length) / 2;
                int n2 = 0;
                if (!Ess.getMasterMute() && !AudioInput.this.rMute) {
                    float f = AudioInput.this.rVolume / 65534.0f;
                    for (int i = 0; i < n; i += 2) {
                        AudioInput.this.buffer[n2++] = (float)(Ess.getFrame(byArray, i) + Ess.getFrame(byArray, i + 1)) * f;
                    }
                }
                for (int i = n2; i < AudioInput.this.buffer.length; ++i) {
                    AudioInput.this.buffer[i] = 0.0f;
                }
                if (AudioInput.this.updateBuffer2) {
                    System.arraycopy(AudioInput.this.buffer2, AudioInput.this.buffer.length, AudioInput.this.buffer2, 0, AudioInput.this.buffer.length);
                    System.arraycopy(AudioInput.this.buffer, 0, AudioInput.this.buffer2, AudioInput.this.buffer.length, AudioInput.this.buffer.length);
                }
                AudioInput.this.bufferStartTime = AudioInput.this.rBufferStartTime = Ess.parent.millis();
                try {
                    AudioInput.this.audioInputDataMethod.invoke((Object)Ess.parent, AudioInput.this.thisInput);
                }
                catch (Exception exception) {}
            }
            AudioInput.this.state = AudioInput.this.rState = 1;
        }

        private void stop() {
            this.kill = true;
            while (AudioInput.this.rState != 1) {
            }
        }
    }
}

