import krister.Ess.*; 

AudioChannel myChannel; 
FFT myFFT;


float laenge = 0.3; // length of the strokes per frame
float schwellwert = 1.5; // thereshold for highlight color

int spektrum_min = 25; // min value of the FFT spectrum
int spektrum_max = 180; // max value of the FFT spectrum

frequenz  [] frequenzArray = new frequenz[spektrum_max+1]; // Array of the used frequenzes

int x_mitte = 150; // x position of the visualization
int y_mitte = 600; // y position of the visualization

float rotation = PI-0.5; // rotation of the visualization

boolean abspielen = true; // Boolean to check if applet is playing or not


void setup() { 

  frameRate(30);
  size (900, 700); 
  smooth();

  noFill();
  background(0);


  Ess.start(this); // init Es
  myChannel=new AudioChannel("beethoven-5th.wav"); // load music file into a new AudioChannel
  myFFT=new FFT(512); // we want 256 frequency bands, so we pass 512
  myChannel.play(); // start the sound 

  // init the frequenz Objects
  for (int i=spektrum_min; i<spektrum_max; i++) { 
    frequenzArray[i] = new frequenz();
  }

} 


void draw() { 

  if (abspielen) { // if music is playing

    myFFT.getSpectrum(myChannel); // load our spectrum 

    for (int i=spektrum_min; i<spektrum_max; i++) { // for the defined channel spectrum

      float temp=min(50, max(0, (myFFT.spectrum[i]*4000))); //get the value of the current channel
      frequenzArray[i].zeichnen(temp, i); //draw the channel
    }

  }
} 

// Frequenz Class
// draw the line for a frequenz channel 
class frequenz {
  float x; 
  float y;
  float x2;
  float y2;

  frequenz() {
    x = x_mitte;
    y = y_mitte;
  }

  void zeichnen (float wert, int faecher) {
    
    //calculating the next x and y positions
    y2 = laenge * sin(radians((wert)*100)+(PI/spektrum_max * faecher)+rotation);
    x2 = laenge * cos(radians((wert)*100)+(PI/spektrum_max * faecher)+rotation); 
    
    if (wert > schwellwert) { 
      // if value higher then the thereshold draw orange line
      strokeWeight(1);            
      stroke(255,183,0, 50);               
      line (x, y, x+x2, y+y2); 
    } 
    else {
      // if value lower then the thereshold draw white line      
      strokeWeight(0.5); 
      stroke(255, 255, 255, 60);         
      line (x, y, x+x2, y+y2); 
    }  

    // set start x and y     
    x = x+x2;
    y = y+y2;      
  }
}


void audioChannelDone(AudioChannel ch) {
  // event if channel stops
  abspielen = false;
  print("Fertig");
}




public void stop() { 
  // event if applet stops
  Ess.stop(); 
  super.stop(); 

} 



